*******************************************************************************
*                         680xx Grundprogramm smenue                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                            Hauptmensteuerung                               *
*******************************************************************************


smenue:                         * Spezialmen mit allen Teilen auf einer Seite
 bsr clrall                     * Bildschirm lschen
 moveq #$ff,d7                  * Achtung !!! d7 ist lokaler Sekundenmerker
 lea ausbuf(a5), a0
 lea menue(pc),a1
smena00:
 move.b (a1)+, (a0)+            * menue Text nach ausbuf kopieren
 bne.s smena00
 subq.l #1, a0                  * Null raus
 bsr prtcpu
 subq.l #1, a0                  * Null raus
 bsr prtvers                    * Versionsnummer nach ausbuf
smena20:
 lea ausbuf(a5),a0
 moveq #$33,d0
 move #220,d2
 bsr centertxt                  * berschrift
 lea smentxt(pc),a0
 moveq #$21,d0
 moveq #5,d1
 move #206,d2
 bsr textprint                  * Men Teil 1
 lea smentxt0(pc),a0
 move #269,d1
 bsr textprint
 btst.b #2,menflag(a5)
 beq.s smen1                    * Grundprogramm nicht als Aufruf, dann weiter
 lea smentxt1(pc),a0
 moveq #$21,d0
 move #269,d1
 moveq #126,d2
 bsr textprint                  * Da Grundprogramm als Aufruf mit 'Z = BEENDEN'
smen1:
 lea smentxt4(pc),a0            * 1. Infozeile
 lea ausbuf(a5),a1              * Nach ausbuf bringen
smen2:
 move.b (a0)+,(a1)+             * bertragen bis Null
 bne.s smen2
 lea ausbuf+10(a5),a0
 move.l stxtxt(a5),d0
 bsr print8x                    * Editoranfangsadresse einfgen
 move.b #' ',(a0)
 lea ausbuf+30(a5),a0
 move.l etxtxt(a5),d0
 bsr print8x                    * Editorendadresse
 move.b #' ',(a0)
 lea symtab(a5),a0
 move.l a0,d0
 lea ausbuf+50(a5),a0
 bsr print8x                    * Symboltabellenstart
 move.b #' ',(a0)
 moveq #0,d0
 move symnext(a5),d0
 lea symtab(a5),a0
 add.l a0,d0
 lea ausbuf+70(a5),a0
 bsr print8x                    * Symboltabellenende
 lea ausbuf(a5),a0
 moveq #$11,d0
 moveq #5,d1
 moveq #13,d2
 bsr textaus                    * Zeile ausgeben
 moveq #83,d3
 bsr umrande                    * Mit Umrandung
smen3:
 lea smentxt2(pc),a0            * 2. Infozeile
 lea ausbuf+2(a5),a1
smen4:
 move.b (a0)+,(a1)+
 bne.s smen4                    * Auch bertragen
 subq.l #1,a1                   * Null ignorieren
 moveq #0,d0
 move.b iostat(a5),d0           * Ausgabe-Kanal holen
 lsl #4,d0                      * Fr Textberechnung
 lea smentxt3-16(pc),a0         * -16, da iostat Bereich  1..6 hat
 adda.l d0,a0                   * Adresse Text berechnet
smen5:
 move.b (a0)+,(a1)+             * bertragen
 bne.s smen5
 clr d1
 move.b groesse(a5),d1
 lsr #4,d1                      * X-Gre holen
 bne.s smen50
 moveq #16,d1                   * Null ist Vergrerung 16
smen50:
 moveq #80,d0
 divs d1,d0                     * Zeichen pro Zeile berechnen
 lea ausbuf(a5),a0
 bsr print4d                    * Und in Infozeile einfgen
 move.b #' ',(a0)
 tst.b debug(a5)
 beq.s smen6                    * Debug aus, dann nichts ndern
 move.l #'an  ',ausbuf+32(a5)   * Text, da Debug an ist einfgen
smen6:
 lea ausbuf(a5),a0
 moveq #$11,d0
 moveq #5,d1
 moveq #2,d2
 bsr textaus                    * 2. Infozeile ausgeben
 moveq #83,d3
 bsr umrande                    * Mit Umrandung
smen7:
 tst.b uhrausw(a5)
 beq.s smen8                    * Keine Uhr an, dann weiter
 lea einbuf(a5),a0
 bsr getuhr                     * Uhrzeit holen
 move.b einbuf+6(a5),d0
 cmp.b d7,d0
 beq.s smen8                    * Alte Zeit = Neue Zeit, dann nicht ausgeben
 move.b d0,d7                   * Sekunden merken
 lea ausbuf(a5),a0
 moveq #2,d0                    * Anzahl Buchstaben fr Tag
 bsr uhrprt0                    * Uhrzeit umwandeln
 lea ausbuf(a5),a0
 moveq #$11,d0
 move #365,d1
 moveq #2,d2
 bsr textaus                    * Uhrzeit ausgeben
smen8:
 bsr csts                       * Zeichen von Tastatur da
 beq.s smen7                    * Nein, nochmal
 bsr ki                         * Zeichen als Grobuchstaben holen
 btst.b #2,menflag(a5)
 beq.s smen9                    * Grundprogramm als Aufruf, dann weiter
 cmp.b #'Z',d0                  * Sonst ist 'Z' nicht erlaubt
 bne.s smen9
rts
smen9:
 cmp.b #':',d0                  * Kleiner als ':', dann Optionen
 bmi.s smen10
 cmp.b #'A',d0                  * Kleiner als 'A', dann Fehler
 bmi smen7
 cmp.b #'Y',d0                  * Grer als 'Y', dann auch Fehler
 bhi smen7
 lea grundtab-'A'(pc),a1
 add d0,d0
 move -'A'(a1,d0),d1
 jsr 'A'(a1,d1)                 * Programm anspringen
bra smenue                       * Zurck

smen10:
 sub.b #'0',d0
 bmi smen7                      * Kleiner als Null, dann Fehler
 bsr.s smenue1
bra smen3

smenue1:
 tst.b d0                       * Maus an/aus
 bne.s smenue10
rts

smenue10:
 cmp.b #1,d0
 beq groess21                   * 40 Zeichen pro Zeile
 cmp.b #2,d0
 beq groess11                   * 80 Zeichen pro Zeile
 cmp.b #3,d0
 beq debugein                   * Debug an
 cmp.b #4,d0
 beq debugaus                   * Debug aus
 cmp.b #9,d0
 beq.s smenue2                  * Uhr stellen
 subq.b #4,d0
 move.b d0,iostat(a5)           * Ausgabekanal whlen
rts

smen2tab:                       * X-Pos, Nummer Zeichen, untere Grenze, obere Gr
 dc.w 365,5,1,7
 dc.w 389,2,1,31
 dc.w 407,3,1,12
 dc.w 425,4,0,99
 dc.w 449,0,0,23
 dc.w 467,1,0,59
 dc.w 485,6,0,59

smenue2:
 tst.b uhrausw(a5)
 beq carset                     * Keine Uhr an, dann Ende
 lea einbuf(a5),a0
 bsr getuhr                     * Uhrzeit holen
 lea smen2tab(pc),a6
 moveq #7-1,d7                  * 7 Werte holen
smenue21:
 movem (a6),d1/d2               * Daten holen
 lea einbuf(a5),a4
 adda.l d2,a4                   * Position des Uhrzeitwertes in einbuf
 move.b (a4),d0
 lea ausbuf(a5),a0
 bsr print2x                    * Alten Wert in ASCII wandeln
 lea ausbuf(a5),a0
 moveq #$11,d0
 moveq #2,d2
 moveq #0,d3
 bsr readaus                    * Wert ndern
 bcs carset                     * Abbruch
 lea ausbuf(a5),a0
 bsr wertmfeh                   * Wert berechnen
 bcs.s smenue21                 * Fehler
 movem 4(a6),d2/d3              * Vergleichswerte fr obere und untere Grenze
 cmp d2,d0
 bmi.s smenue21                 * Falscher Wert
 cmp d0,d3
 bmi.s smenue21                 * Falscher Wert
 divu #10,d0
 move.b d0,d1
 lsl.b #4,d1
 swap d0
 add.b d1,d0
 move.b d0,(a4)                 * In BCD-Code gewandelt
 addq.l #8,a6                   * Tabelle weiter
dbra d7,smenue21
 moveq #$ff,d7                  * Sekundenmerker rcksetzen
 lea einbuf(a5),a0
bra setuhr                      * Uhrzeit setzen

lstolf:
 move.b #4,iostat(a5)           * Auf Drucker ohne LF
rts

mass:
 bsr assemble                   * Assembler aufrufen
bra finmenue                    * Ende

prtcpu:                         * CPU-Name nach a0
 movem.l d0/a1, -(a7)
 move.l cpuwert(pc), d0
 cmp.l #1, d0
 bne.s prtcpu01
 lea cpu1(pc), a1               * 68008
 bra.s prtcpu10
prtcpu01:
 cmp.l #2, d0
 bne.s prtcpu02
 lea cpu2(pc), a1               * 68000
 bra.s prtcpu10
prtcpu02:
 lea cpu4(pc), a1               * 68020
prtcpu10:
 move.b (a1)+, (a0)+            * CPU-Name nach ausbuf
 bne.s prtcpu10
 movem.l (a7)+, d0/a1
 rts

prtvers:                        * Versionsnummer als ASCII nach a0
 movem.l d0-d1, -(a7)
 move.l versnum(pc), d0         * Versionsnummer
 move.b #'V', (a0)+
 move.b #' ', (a0)+
 rol #4, d0                     * nur unteres Wort wird beachtet
 move.b d0, d1
 and.b #$0f, d1                 * 10er Stelle
 beq.s prt1vers                 * war Null, dann nicht
 add.b #'0', d1
 move.b d1, (a0)+
prt1vers:
 rol #4, d0
 move.b d0, d1
 and.b #$0f, d1                 * 1er Stelle
 add.b #'0', d1
 move.b d1, (a0)+
 move.b #'.', (a0)+             * Der Punkt
 rol #4, d0
 move.b d0, d1
 and.b #$0f, d1                 * 1/10 Stelle
 add #'0', d1
 move.b d1, (a0)+
 rol #4, d0
 and #$0f, d0
 add.b #'0', d0
 move.b d0, (a0)+               * 1/100 Stelle
 clr.b (a0)+                    * und ne Null
 movem.l (a7)+, d0-d1
 rts
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             